<?php
$fit_thumb = get_sub_field('fit_thumb');
$offer_id = get_sub_field('offer_id');
$show_text = get_sub_field('show_text');
$show_vertical = get_sub_field('show_vertical');
$subpage_image_div = get_sub_field('subpage_image_div');
$subpage_image_div_height = get_sub_field('subpage_image_div_height');
$subpage_show = get_sub_field('show_slider');
$slider_columns = get_sub_field('slider_columns');
$list_columns = get_sub_field('list_columns');
$exclude_this = get_sub_field('exclude_this');
$link_absolute = get_sub_field('link_absolute');
$exclude_this_id = get_the_ID();
if( $offer_id ): 
	$post = $offer_id;
	setup_postdata( $post ); 
	$offer_id_value = $post->ID;
else:
	$offer_id_value = get_the_ID();
endif;
if ($exclude_this) {
	$parent = new WP_Query( 
		array(
			'post_type' => 'page',
			'post_parent' => $offer_id_value,
			'orderby' => 'menu_order',
			'order' => 'ASC',
			'post_status' => 'publish',
			'posts_per_page' => -1,
			'caller_get_posts'=> 1,
			'post__not_in' => array($exclude_this_id)
		)
	);	
} else {
	$parent = new WP_Query( 
		array(
			'post_type' => 'page',
			'post_parent' => $offer_id_value,
			'orderby' => 'menu_order',
			'order' => 'ASC',
			'post_status' => 'publish',
			'posts_per_page' => -1,
			'caller_get_posts'=> 1
		)
	);	
}
wp_reset_postdata();

if ( $parent->have_posts() ) : ?>
	<div class="nav-submenu section-offer<?php if ($subpage_show == 'slider') echo ' owl-carousel owl-'.$slider_columns.'-loop'; else echo ' row'; ?>">
		<?php while ( $parent->have_posts() ) : $parent->the_post(); ?>
			<div id="id-<?php the_ID(); ?>" class="<?php if ($show_vertical) echo 'row'; elseif (!$show_slider) echo 'col-sm-'. 24/$list_columns; ?> marginbottom">
				<?php if (!$show_vertical) { ?>
					<div class="item text-center relative">
				<?php } ?>
					<?php if ($link_absolute) { ?>
						<a href="<?php the_permalink(); ?>" class="link-absolute"></a>
					<?php } ?>
					<?php if ( has_post_thumbnail() ) {
						$thumb_id = get_post_thumbnail_id($post->ID);
						$image_alt = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true); ?>
						<?php if ($show_vertical) { ?>
							<div class="col-sm-8">
						<?php } ?>
							<a href="<?php the_permalink(); ?>" class="hover-link">
								<?php if ($subpage_image_div) { ?>
									<div class="thumbnail-<?php if ($fit_thumb) echo 'contain'; else echo 'cover'; ?> thumbnail-<?php echo $subpage_image_div_height; ?>" style="background-image: url(<?php echo wp_get_attachment_url($thumb_id); ?>);"></div>
								<?php } else { ?>
									<img src="<?php echo wp_get_attachment_url($thumb_id); ?>" alt="<?php echo $image_alt; ?>">
								<?php } ?>
							</a>
						<?php if ($show_vertical) { ?>
							</div>
						<?php } ?>
					<?php } ?>
					<?php if ($show_vertical) { ?>
						<div class="col-sm-16">
					<?php } ?>
						<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						<?php if ($show_text) { ?>
							<?php if (get_field('intro')) {
								the_field('intro');
							} else {
								the_excerpt();
							}
						} ?>
					<?php if ($show_vertical) { ?>
						</div>
					<?php } ?>
				<?php if (!$show_vertical) { ?>
					</div>
				<?php } ?>
			</div>
		<?php endwhile; ?>
	</div>
<?php endif;
wp_reset_query(); ?>